--[[---------------------------------------------------------------------------
	Chocolatier Two Ledger: Messages
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local messageLineScroll = 7

local function updateScrollButtons()
	if gSim.messageTop > 1 then EnableWindow("scroll_up", true)
	else EnableWindow("scroll_up", false)
	end
	
	if gSim.messageTop < (bsgGetMaxScroll("messageText") + 1) then EnableWindow("scroll_down", true)
	else EnableWindow("scroll_down", false)
	end
end

local function scrollUp()
	if gSim.messageTop <= messageLineScroll then
		gSim.messageTop = 1
		bsgSetStartLine("messageText", gSim.messageTop)
		updateScrollButtons()
	else
		gSim.messageTop = gSim.messageTop - messageLineScroll
		bsgSetStartLine("messageText", gSim.messageTop)
		updateScrollButtons()
	end
end

local function scrollDown()
	local max = bsgGetMaxScroll("messageText") + 1
	if (gSim.messageTop < max) then
		gSim.messageTop = gSim.messageTop + messageLineScroll
		if gSim.messageTop > max then gSim.messageTop = max end
		bsgSetStartLine("messageText", gSim.messageTop)
		updateScrollButtons()
	end
end

local function scrollBottom()
	gSim.messageTop = bsgGetMaxScroll("messageText") + 1
	bsgSetStartLine("messageText", gSim.messageTop)
	updateScrollButtons()
end

-------------------------------------------------------------------------------

gSim:ConcatenateMessages()

MakeDialog
{
	Text { x=0,y=10,w=ui.ledgerWidth-26,h=ui.ledgerHeight, name="messageText", label=gSim.messageText, font=dialogFont, flags=kHAlignLeft+kVAlignTop },

	Button { x=ui.ledgerWidth-24,y=48, command=scrollUp, name="scroll_up",
			graphics={"control/scrollup_up", "control/scrollup_down", "control/scrollup_over"}
	},
	
	Button { x=ui.ledgerWidth-24,y=86, command=scrollDown, name="scroll_down",
			graphics={"control/scrolldown_up", "control/scrolldown_down", "control/scrolldown_over"},
	},
}

--bsgSetStartLine("messageText", gSim.messageTop)
--updateScrollButtons()
scrollBottom()
